/*
    This C-File gets linked to GFA-BASIC for Windows Compiler
    TESTC1.GFW
*/

#include <windows.h>
#include "gfa.h"

GVLONG L_X;    // x%

void far pascal TestC(int x,int y,int w,int h,int wid)
{
    HPEN OldPen;
    HPEN Black = GetStockObject(BLACK_PEN);
    HPEN White = GetStockObject(WHITE_PEN);
    HPEN tmp;
    char Strg[20];
    OldPen = SelectObject(V_DCA,Black);
    for(;;)
	{
	MoveTo(V_DCA,x + w,y	);
	LineTo(V_DCA,x + w,y + h);
	LineTo(V_DCA,x	  ,y + h);
	SelectObject(V_DCA,White);
	LineTo(V_DCA,x	  ,y	);
	LineTo(V_DCA,x + w,y	);
	if(--wid < 0) break;
	x++; y++; w -= 2; h -= 2;
	tmp = Black; Black = White; White = tmp;
	}
    SelectObject(V_DCA,OldPen);
    wsprintf(Strg,"%8ld",L_X);
    TextOut(V_DCA,x,y + (h >> 1),Strg,8);
}

// version 1: macht nur Text x,y,a$
//GPROC TESTC_STR(GWORD x,GWORD y,GSTRG strg)
//{
//    TextOut(V_DCA,x,y,G_ADR(strg),G_LEN(strg));
//    G_SKILL(strg);
//}

// version 2: macht auch Text x,y+30,@MirrTxt$(a$)
GFUNCS S_MIRRTXT(GSTRG strg);

GPROC TESTC_STR(GWORD x,GWORD y,GSTRG strg)
{
    GSTRG mirrs;
    __REGS.x.cx = G_LEN(strg);	    //just an example using _CX
    TextOut(V_DCA,x,y,G_ADR(strg),G_LEN(strg));
    mirrs = S_MIRRTXT(strg);
    TextOut(V_DCA,x,y+30,G_ADR(mirrs),G_LEN(mirrs));
    G_SKILL(mirrs);
    G_SKILL(strg);
}
