

V24G.SYS

Schnittstellen-Treiber fr GFA-Basic

(c) Shamrock Software GmbH 1993



Eigenschaften des Treibers

V24G.SYS ist ein RAM-resident ladbares Treiberprogramm fr IBM-kompatible PCs und ATs zur bequemen Bedienung serieller Schnittstellen aus hheren Programmiersprachen. Empfangsseitig ist ein Puffer vorhanden, damit Zeichen auch im Hintergrund empfangen werden knnen, wenn das aufrufende Anwenderprogramm gerade beschftigt ist. Eine zustzlicher Sende-Puffer sorgt fr die Entlastung des Anwenderprogramms beim Senden.

Das Treiberprogramm lt sich von allen Programmiersprachen mit den logischen Gertenamen RS1, RS2 usw. ansprechen. Baudrate und bertragungsparameter lassen sich fr alle Schnittstellen getrennt jederzeit neu setzen.

Durch das Konzept, den Treiber als echten MS-DOS-Gertetreiber auszufhren, wird die Ein- und Ausgabe von hheren Programmiersprachen sehr einfach und erfordert keine Assembler-Unterprogrammaufrufe. Vielmehr werden die normalen DOS-Funktionen zur Ein- und Ausgabe genutzt.

Die Ihnen vorliegende Version V24G.SYS ist ein fr den Vertrieb zusammen mit GFA-Basic lizenzierter Spezialtreiber. Eine erheblich erweiterte Treiber-Version V24.SYS ist bei Shamrock Software, 85238 Petershausen, erhltlich. Die Eigenschaften beider Versionen sind im wesentlichen:

			GFA-Version	Vollversion
Parameter		V24G.SYS	V24.SYS
------------------------------------------------------
Schnittstellen		COM1+COM2	COM1...COM9
FIFO-Benutzung (16550)	Ja		Ja
XON/XOFF-Protokoll	Ja		Ja
RTS/CTS-Protokoll	Ja		Ja
Maximale Baudrate	38400		115200
Empfangspuffer		512 Byte	0...60 KByte
Sendepuffer		16 Byte		0...255 Byte
IRQ-Sharing mglich	-		Ja
User-Interrupt		-		Ja
V.23 (1200/75 Bd)	-		Ja
Timeout-Programmierung	-		Ja
8N2 mglich		-		Ja
Ansteuern von DTR/RTS	-		Ja
Break-Steuerung		-		Ja
Beispielprogramme	GFA-Basic	Basic, Pascal, C

Trotz aller Unterschiede sind beide Treiberversionen programmtechnisch kompatibel: Ein mit V24G.SYS entwickeltes Programm funktioniert sofort auch mit der "Vollversion" V24.SYS.


Laden mit CONFIG.SYS

Das Treiberprogramm kann mit Hilfe der von MS-DOS beim Einschalten des Rechners automatisch geladenen Datei CONFIG.SYS als residente Betriebssystem-Erweiterung eingebunden werden. Es ist zulssig, ein und dasselbe Treiberprogramm V24G.SYS zweimal nacheinander zu laden, um die Schnittstellen COM1 und COM2 gleichzeitig bedienen zu knnen. Wenn CONFIG.SYS die Zeile

		DEVICE=V24G.SYS

(mit Return abgeschlossen) enthlt und die Datei V24G.SYS sich im Hauptverzeichnis des Boot-Laufwerks befindet, wird der Treiber mit seinen Standard-Einstellungen geladen. Diese sind:

   Schnittstelle:	COM1
   Baudrate:		4800 Bd
   Datenformat:		8 Datenbits, keine Paritt, 1 Stopbit
   XON/XOFF-Handshake:	Ausgeschaltet
   RTS/CTS-Handshake:	Ausgeschaltet

Selbstverstndlich kann man hinter DEVICE= auch einen Pfadnamen angeben, z.B. DEVICE=C:\DOS\V24G.SYS, wenn sich der Treiber in einem Unterverzeichnis der Festplatte befindet. Gro- oder Kleinschreibung spielt keine Rolle.

Hinter dem Dateinamen V24G.SYS (gefolgt von mindestens einem Leerzeichen) knnen zahlreiche Parameter angegeben werden, um den Treiber anwendungsspezifisch zu konfigurieren. Ein einfaches Beispiel:

		DEVICE=V24G.SYS C2 B2 PH

Diese Zeile konfiguriert das Treiberprogramm fr die zweite serielle Schnittstelle mit 300 Baud (B2) sowie acht Datenbits mit ungerader Paritt und einem Stopbit (PH). Die Leerrume zwischen den Parametern sind optional. Insgesamt untersttzt V.24-OEM folgende Parameter (in alphabetischer Reihenfolge):

Bx	Es wird die Baudrate x voreingestellt; x steht fr:
	0   75		4  1200		8  19200
	1  110		5  2400		9  38400
	2  300		6  4800
	3  600		7  9600

	Wenn der Parameter B fehlt, wird eine Geschwindigkeit
	von 4800 Baud angenommen (entsprechend B6).

Cx	Der Treiber wird fr die x-te serielle Schnittstelle
	geladen, wobei fr x den Wert 1 oder 2 haben kann.

H	Es wird ein RTS-/CTS-Hardware-Handshake aktiviert:
	Der Treiber wartet mit dem Senden, bis CTS=1 ist, und
	legt RTS auf 0, solange der interne Puffer voll ist.

Px	Es wird das Datenformat x voreingestellt. Der
	Buchstabe x hat die folgende Bedeutung:

	A  8N2		D  7N1		G  8E1
	B  8N1		E  7E1		H  8O1
	C  7N2		F  7O1

	Hierbei bedeutet zum Beispiel "8N1" acht Datenbits,
	keine Paritt (N=no=keine, E=even=gerade, O=odd=
	ungerade) und ein Stopbit. Diese Konfiguration 8N1
	(entsprechend dem Parameter PB) ist auch eingestellt,
	wenn der Parameter P nicht verwendet wird.

X	Mit dem Parameter X wird sende- und empfangsseitig
	das XON/XOFF-Software-Handshake aktiviert. Ohne
	diesen Parameter werden die Zeichen XON und XOFF
	nicht ausgewertet, sondern transparent bergeben.

Falls in der Datei CONFIG.SYS hinter dem Dateinamen des Treibers (V24G.SYS) falsche Parameter stehen, gibt das Programm beim Laden eine Fehlermeldung aus. Es wird dann zwar in den Speicher geladen, sollte aber nicht verwendet werden, da nur ein Teil der angegebenen Parameter ausgewertet werden konnte.

In den meisten Fllen drfte folgende Angabe in CONFIG.SYS zur Verwendung des Treibers ausreichen:

		DEVICE = V24G.SYS		(fr COM1)
und/oder	DEVICE = V24G.SYS C2		(fr COM2)

Nach dieser Installation ist die erste Schnittstelle unter den "Datei"-Namen RS1 und RS1X ansprechbar, die zweite mit RS2 und RS2X und so weiter. Da jeder Schnittstelle zwei gleichwertige Namen zugeordnet sind, kann man einen Namen zum ffnen einer Datei zum Lesen und den anderen zum ffnen einer zweiten Datei zum Schreiben zuweisen, ohne da z.B. in Basic eine Fehlermeldung wie "File Already Open" auftreten wrde.


Ein- und Ausgabe via DOS

Da V.24-OEM ein echter, mit Namen ansprechbarer Gertetreiber ist, kann man einfache DOS-Anweisungen verwenden, um Daten ber eine serielle Schnittstelle ein- und auszugeben. Die wesentlichen Unterschiede zur "normalen" DOS-Schnittstelle COM1 bzw. COM2 sind:

 Die Gertenamen lauten RS1 und RS2 statt COM1 und COM2.
  Die DOS-Namen COM1 und COM2 sind wie bisher benutzbar.
 Der Treiber bleibt bei nicht angeschlossenen Hardware-
  Steuerleitungen (CTS, DSR usw.) nicht hngen, sofern
  nicht ausdrcklich ein RTS/CTS-Protokoll aktiviert wird.
 Die Ein- und Ausgabe erfolgen gepuffert, so da auch bei
  hheren Baudraten keine Zeichen verloren gehen.
 Das XON/XOFF-Software-Protokoll wird untersttzt, wenn
  der Treiber entsprechend konfiguiert wird.
 Es sind auch hhere Baudraten als 9600 Bd mglich.

Um z.B. eine Datei ABC.TXT ber die erste Schnittstelle mit Hilfe des Treibers auszugeben, gibt man in DOS folgendes ein:

		C>COPY ABC.TXT RS1

Selbstverstndlich sind auch andere DOS-Befehle auf den Treiber anwendbar, zum Beispiel TYPE RS1, um empfangene Daten bis zum Auftreten eines CTRL-Z-Steuerzeichens auf dem Bildschirm anzuzeigen.

Diese Art der Treiber-Verwendung ist allerdings alles andere als komfortabel. Im nchsten Kapitel wird deshalb auf das Ansprechen der Schnittstellen aus Anwenderprogrammen eingegangen. Damit ist es auch mglich, zahlreiche Parameter wie Baudrate, Datenformat und so weiter auch im laufenden Betrieb jederzeit zu ndern.


Programmieren mit V.24-OEM

V.24-OEM eignet sich fr alle gngigen Programmiersprachen. Es werden dabei die normalen DOS-Ein- und Ausgabe-Funktionen verwendet, z.B. Open, Close, Print#, Input# und so weiter.

GFA-Basic weist allerdings gegenber anderen Basic-Varianten und sonstigen Programmiersprachen die Besonderheit auf, da zur Erhhung der Ein-/Ausgabegeschwindigkeit bei Plattenzugriffen bei PRINT# und INPUT$ zustzliche eigene Puffer benutzt werden, die bei einem zeichenorientierten Gertetreiber wie V24G.SYS hinderlich sind.

Aus diesem Grunde verwendet das mitgelieferte, in GFA-Basic geschriebene Beispiel, das ein kleines Terminalprogramm realisiert, nicht die sonst naheliegenden Befehle wie INPUT$ und PRINT#, sondern empfngt und sendet Zeichen direkt ber das DOS-Interface INT 21H. Funktion 3FH dient zum Empfangen eines Strings und 40H zum Senden.

Ebenso knnen die bei manchen anderen Programmiersprachen vorhandenen Befehle IOCTL# und IOCTL$ dank der Flexibilitt von GFA-Basic auf sehr einfache Weise ber INT-21H-Aufrufe (Funktion 44H) nachgebildet werden, wie das Beispielprogramm ebenfalls zeigt.


IOCTL-Funktionen

MS-DOS stellt mit IOCTL- (I/O-Control-) Funktionen ein brauchbares Mittel zur Steuerung von Treiberprogrammen zur Verfgung. Sie werden ber die INT-21H-Funktion AH=44H, AL=3 realisiert. Einer IOCTL-Anweisung mu stets ein OPEN-Kommando vorausgegangen sein. Wenn ein und dieselbe Schnittstelle gleichzeitig mit zwei Filenummern (fr Ein- und Ausgabe) geffnet wird, ist es gleichgltig, auf welchen der beiden Kanle die IOCTL-Anweisungen angewendet werden; sie gelten stets fr beide.

Die IOCTL-Funktion zur bergabe eines Steuer-Strings an einen DOS-Treiber wird mit folgenden Parametern ber INT 21H aufgerufen:

	AH = 44H, AL = 3 als INT-21H-Funktionsnummer
	BX = Datei-Handle (aus Open-Befehl)
	CX = Lnge des zu bergebenden Steuer-Strings
	DS:DX = Adresse des zu bergebenden Strings

Der V.24-OEM-Treiber versteht eine Reihe von IOCTL-Kommandos. Sie bestehen aus je einem Zeichen und drfen in beliebiger Reihenfolge bergeben werden (Ausnahme "T"). Andere IOCTL-Zeichen als die im folgenden genannten werden vom Treiberprogramm ohne Fehlermeldung ignoriert.

Das GFA-Basic-Beispielprogramm nutzt die IOCTL-bergabe zur Einstellung der Baudrate und verwendet die oben genannten INT-21H-bergabeparameter.

Sie werden feststellen, da die meisten IOCTL-Anweisungen jenen Parametern hneln, die man auch in CONFIG.SYS hinter dem Treibernamen angeben kann.

Wenn die beim Laden des Treibers eventuell angegebenen Parameter nicht verndert werden mssen, sind keine IOCTL-Anweisungen im Programm erforderlich. Baudrate und bertragungsparameter knnen nach einer OPEN-Anweisung beliebig oft mit IOCTL-Kommandos verndert werden. Die OPEN-Anweisung selbst verndert Baudrate und sonstige Parameter nicht.

Einstellen der Baudrate: 0...9

0 =   75 Bd	4 = 1200 Bd	8 =  19200 Bd
1 =  110 Bd	5 = 2400 Bd	9 =  38400 Bd
2 =  300 Bd	6 = 4800 Bd
3 =  600 Bd	7 = 9600 Bd

Einstellen der bertragungsparameter

	A	8 Datenbits, keine Paritt,    2 Stopbits
	B	8 Datenbits, keine Paritt,    1 Stopbit
	C	7 Datenbits, keine Paritt,    2 Stopbits
	D	7 Datenbits, keine Paritt,    1 Stopbit
	E	7 Datenbits, gerade Paritt,   1 Stopbit
	F	7 Datenbits, ungerade Paritt, 1 Stopbit
	G	8 Datenbits, gerade Paritt,   1 Stopbit
	H	8 Datenbits, ungerade Paritt, 1 Stopbit
		(Beim Laden ist "B" voreingestellt.)

Sonstige IOCTL-Kommandos

	I	Treiber neu initialisieren, Puffer lschen
	R	Empfangspuffer lschen
	X	XON/XOFF-Protokoll einschalten (s.u.)
	Y	XON/XOFF-Protokoll ausschalten

Beim Laden sind normalerweise "P" und "Y" voreingestellt.

MS-DOS 2.11 ignoriert intern einen via DOS bergebenen OPEN-Befehl. Deshalb ist hier "I" ntig, um sicherzustellen, da vor einer Ein- und Ausgabe die Interrupt-Vektoren und Puffer-Zeiger korrekt gesetzt werden. "I" lscht gleichzeitig den Empfangspuffer. Bei MS-DOS-Versionen ab 3.0 wird die richtige Initialisierung aber durch eine OPEN-Anweisung automatisch gewhrleistet.

Ein OPEN-Kommando (z.B. in Basic) setzt die RTS- und DTR-Leitungen automatisch auf 1, das entspricht einem elektrischen Pegel von +12 V. Der IOCTL-Befehl I hat dieselbe Wirkung. Eine ClOSE-Anweisung setzt RTS und DTR wieder zurck (-12 V).


XON/XOFF-Protokoll

Beim Start ist der Treiber fr alle Codes transparent, d.h. alle Zeichencodes werden unverndert durchgelassen. Mit dem IOCTL-Kommando "X" oder mit der Option X in CONFIG.SYS lt sich ein XON-XOFF-Protokoll einschalten, mit dem man verhindern kann, da eine Seite die Zeichen schneller sendet, als die andere sie verarbeiten kann.

Bei eingeschaltetem XON/XOFF-Protokoll sind die beiden Zeichen XON (CTRL-Q, Code dezimal 17 bzw. hex 11) und XOFF (CTRL-S, dezimal 19 bzw. hex 13) natrlich nicht bertragbar. Eine vollstndig transparente bertragung ist deshalb nur bei ausgeschaltetem XON/XOFF-Protokoll mglich. Es wird auch empfohlen, das Senden von CTRL-S und CTRL-Q aus dem Anwenderprogramm heraus zu vermeiden, wenn das XON/XOFF-Protokoll eingeschaltet ist, damit keine Konflikte mit der Protokollsteuerung auftreten.

Wird ein XOFF-Zeichen empfangen, so wird mit dem Fllen des Sendepuffers solange gewartet, bis ein XON-Zeichen empfangen wird. (Hierbei gibt es kein Timeout, d.h. der Rechner kann beliebig lange warten.)

Durch Abfrage von Bit 0 im dritten Byte des IOCTL$-Strings kann festgestellt werden, ob der Treiber gerade im XOFF-Status ist, so da im Moment kein Zeichen gesendet werden kann (siehe nchstes Kapitel). Ein Anwenderprogramm kann dadurch verhindern, da es "hngt", nachdem die Gegenstation ein XOFF-Zeichen gesendet hat.

Wenn der Empfangspuffer halb voll wird, sendet der Treiber ein XOFF-Zeichen, um die Gegenstation anzuhalten. Sobald das Anwenderprogramm den Empfangspuffer soweit geleert hat, da er nur noch zu einem Viertel gefllt ist, sendet der Treiber ein XON-Zeichen.

Das Senden eines XOFF-Zeichens (sobald der Empfangspuffer halb voll wird) erfolgt im Hintergrund, d.h. innerhalb einer Interrupt-Routine, und funktioniert daher auch, wenn das aufrufende Anwenderprogramm gerade anderweitig beschftigt ist. Wenn es jedoch gerade selbst Strings ohne Pause zwischen den einzelnen Zeichen sendet, wird kein XOFF-Zeichen ausgegeben, um Konflikte mit dem gesendeten String zu vermeiden.


Hardware-Handshake

Der Treiber kann ein RTS-/CTS-Hardware-Handshake automatisch durchfhren, wenn er beim Laden mit der Option H passend konfiguriert wurde. Das Puffer-Verhalten entspricht dem bei XON/XOFF. Das Hardware-Handshake ist jedoch nicht per IOCTL-Anweisung ein- oder ausschaltbar. XON/XOFF (Option X) und RTS/CTS (Option H) sollten nie gleichzeitig aktiviert werden - das wre aber auch wenig sinnvoll.


Abfrage von Statusangaben

Die IOCTL-Parameter-bergabe funktioniert auch in der anderen Richtung, also vom Treiberprogramm zum aufrufenden Anwenderprogramm. Hierbei werden folgende Parameter fr INT 21H verwendet:

	AH = 44H, AL = 2: INT-21H-Funktionsnummer
	BX = Datei-Handle (aus Open-Befehl)
	CX = Lnge des abzuholenden Status-Strings
	DS:DX = Adresse des abhzuholenden Strings

Im Falle von V24G.SYS ist der so abgeholte String immer vier Byte lang und folgendermaen aufgebaut:

1. und 2. Byte:	Zahl der Zeichen im Puffer (binr, low/high,
		kann direkt als 16-Bit-Integer bernommen
		werden)

3. Byte:	Status der Schnittstelle (binr):
		Bit 0 = Sender im XOFF-Status (wenn Bit=1)
		Bit 1 = Parity-Fehler aufgetreten
		Bit 2 = Framing-Fehler aufgetreten
		Bit 3 = Break empfangen (d.h. RxD = 0)
		Bit 4 = CTS (Clear To Send)
		Bit 5 = DSR (Data Set Ready)
		Bit 6 = RI  (Ring Indicator)
		Bit 7 = CD  (Carrier Detect)
		Das zur Abfrage (UND-Verknpfung) erforder-
		liche "Masken-Byte" ist je nach Bit:

		Bit-Nr.		0  1  2  3  4  5  6  7
		UND-Maske	1  2  4  8  16 32 64 128

		Zum Beispiel ist eine CTS-Abfrage so mglich:
		IF(ASC(MID$(E$,3,1)))AND 16 THEN PRINT"CTS=1"

		Wenn Bit 0 = 1 ist (XOFF-Status), knnen kei-
		ne Zeichen gesendet werden, bis die Gegensta-
		tion ein XON-Zeichen sendet oder das XON-/
		XOFF-Protokoll ausgeschaltet wird. Ein Test
		dieser Bedingung ist wie folgt mglich:
		IF(ASC(MID$(E$,3,1)))AND 1 THEN PRINT"XOFF!"

4. Byte:	Empfangs-Status des Treiberprogramms (ASCII):
		" " (Leerraum, dez. Code 32) = kein Fehler,
		"E" = Parity-/Framing-Fehler oder Break
		"B" = Empfangspuffer-berlauf

		Beispiel zum allgemeinen Fehlertest:
		IF RIGHT$(E$,1)<>" "THEN PRINT"Fehler!!!"

Das Lesen des Fehlercodes ist nur einmal mglich, da jede IOCTL-Leseanweisung den Fehlerstatus automatisch wieder lscht. Das gilt auch fr die Bits 1 bis 3 im IOCTL-Byte 3.

Nach einem Pufferberlauf (Fehlerstatus B) befinden sich jeweils die zuletzt empfangenen Bytes noch im Puffer. Der Fehlerstatus E gibt an, da seit dem letzten Lesen des IOCTL-Strings ein Paritts- oder Framing-Error auftrat; es ist jedoch nachtrglich nicht mglich, noch festzustellen, welches empfangene Zeichen hierfr die Ursache war.


Nutzungsbedingungen fr V24G.SYS

Sie drfen den Treiber V24G.SYS, jedoch ohne die zugehrige Dokumentation, zusammen mit einem von Ihnen selbst entwickelten GFA-Basic-Programms an Endanwender weitergeben. V24G.SYS darf jedoch nicht einzeln und nicht gegen Entgelt weitergegeben werden. Es ist nicht zulssig, den Copyright-Vermerk aus dem Treiberprogramm zu entfernen oder das Programm in sonstwie genderter Form weiterzugeben.

Der Hersteller garantiert nicht die Eignung dieses Treibers fr eine bestimmte Hardware oder Anwendung und bietet eine telefonische oder schriftliche Beratung ausschlielich fr die optional lieferbare Vollversion V24.SYS an. Diese Vollversion knnen Sie beziehen von: Shamrock Software GmbH, Mnchner Str. 26 a, D-85238 Petershausen, Telefon+Telefax 08137 / 5882.
