'SUB GIFREAD4       'This updated routine decodes a .GIF file, displays it
		    'onscreen, BSAVES a 320x200 portion of the image to a new
		    'binary file that can be instantly regenerated on the
		    'screen by the complimentary program "FASTER4.BAS."
' These routines were written in Power Basic in September of 1991 by
' Robert Mason of Houston, Texas, Voice Line(713)477-0201 #531.
'
' I wrote this because I was curious about how "those picture files" like
' CompuServe's Graphics Interchange Format worked, and because I wanted to have
' a PowerBasic module that would allow me to use ready-made pictures for my
' other programs.  I have kept the code as simple as I could in
' order to be more instructive, and, although this limits the capabilities of
' the program, it allows easier code evaluation by novices (like me).
' I hope that this program will help other programmers who have been
' wondering "Hmmmmmm, how do they do that?", but are only familiar with BASIC
' programming language (there is a relatively large amount of "C" code for
' viewing GIF images).

'TO RUN THE PROGRAM
' After loading into PowerBasic and executing, type in the name of a .GIF file
' in the current PowerBasic directory and patiently wait while the program
' decodes and "draws" the picture on screen.  After the picture has finished
' generating, you should hear a beep.  Press any key to get the program to
' save a 320x200 portion of the screen to three binary files called GIFBSAVE.1,
' GIFBSAVE.2, and GIFBSAVE.3.  Next, load the program FASTER3.BAS, and run it.
' Three portions of the GIF file you previously viewed will instantly
' appear on your screen.  Good Luck.

'PROGRAM CHANGES
' I have finally fixed that color problem that was in GIFREAD3.BAS!

'PROGRAM LIMITATIONS
' - Requires a color graphics card.
' - Does not have the capability to do interlacing.
' - Will only read the first image.
' - Will sometimes run out of memory when handling large or very detailed
'   images.  If this happens within PB, try compiling it to an .EXE file,
'   exiting PB, and running the .EXE file in DOS.
' - It will recognize a global color table, but not a local color table. This
'   is not a major problem, however, as a lot of the GIF files I have seen have
'   only a global color table.
' - The first part is mind-numbingly slow.

' A SPECIAL THANKS TO STEVE BLACKSTOCK FOR HIS ARTICLE "LZW AND GIF EXPLAINED"


' FURTHER READING/FILES:
' - Ziv, J. and Lempel, A.  "A Universal Algorithm for Sequential Data Compression",
'   IEEE Transactions on Information Theory, May 1977.
' - Welch, T. "A Technique for High-Performance Data Compression", Computer,
'   June 1984.
' - Nelson, M.R. "LZW Data Compression", Dr. Dobb's Journal, October 1989.
' - Blackstock, S. "LZW and GIF Explained", CIS, Graphics Support Forum
'   Library 14, "LZWEXP.TXT", Aug 26, 1987.
' - "Graphics Interchange Format", CIS, Graphics Support Forum Library 17,
'   "GIFSTD.ASC", June 15, 1987.
' - "Graphics Interchange Format", CIS, Graphics Support Forum Library 14,
'   "GIF89a.DOC", July 31, 1990.

DEFINT A-Z
DIM STABLE$(4096)                       'String Table array
DIM GLOBMAP$(255)                       'Global Map Colors array.

INPUT "GIF FILE = ",F$ : F$ = F$ + ".GIF" :OPEN F$ FOR BINARY AS #1

ON KEY (10) GOSUB UNCLE                  'To interrupt the program, hit F10
KEY (10) ON                              'at any time.

CALL SCRENDESCR                          'Get screen descriptor block info.

P = 13                                   'Set pointer to next avail byte.

IF M$ = "1" THEN                         'Now read the global color map, if
FOR S = 12 TO (2^PX)*3 + 9 STEP 3        'any, and convert the color values
  DE& = 0                                'to a 16 color map index.
  FOR G = 0 TO 2
    SEEK #1,G+S+1 : GET$ #1,1,BYTE$      'Get the 3 bytes of each color and
    D(G) = ASC(BYTE$)                    'put them into an array (RGB order).
  NEXT
					 'Convert the true .GIF picture colors
  C = 0 				 'to the BASIC 16 colors.
  IF D(0) > 222 THEN
    IF D(1) > 222 THEN
      IF D(2) > 222 THEN
	C = 15
      ELSE
	C = 14
      END IF
    ELSE
      IF D(2) > 222 THEN
	C = 13
      ELSE
	C = 12
      END IF
    END IF
  ELSE
    IF D(0) > 105 THEN
      IF D(1) > 105 THEN
	IF D(2) > 105 THEN
	  C = 7
	ELSE
	  C = 6
	END IF
      ELSE
	IF D(2) > 105 THEN
	  C = 5
	ELSE
	  C = 4
	END IF
      END IF
    ELSE
      IF D(1) > 105 THEN
	IF D(1) > 222 THEN
	  IF D(2) > 222 THEN
	    C = 11
	  ELSE
	    C = 10
	  END IF
	ELSE
	  IF D(1) > 105 THEN
	    IF D(2) > 105 THEN
	      C = 3
	    ELSE
	      C = 2
	    END IF
	  ELSE
	    IF D(1) > 105 THEN
	      IF D(2) > 105 THEN
		C = 9
	      ELSE
		C = 8
	      END IF
	    ELSE
	      IF D(2) > 105 THEN
		C = 1
	      ELSE
		C = 0
	      END IF
	    END IF
	  END IF
	END IF
      END IF
    END IF
  END IF

 CC = (S-12)/3
 STABLE$(CC) = CHR$(C+1)
 GLOBMAP$(CC) = CHR$(C+1)               'Load colors into global map array.
NEXT

END IF

'OK, now that the Global Color Index has been mapped, and the information
'on "root" characters have been put into the high memory as a string table,
'let's start printing the picture.

STLEN = 2^N + 2                         'Set the first available place to
					'put the first output to the string
					'table from the data stream
P = S + 1                               'Increment the .GIF file pointer

DO                                      'Repeat the following for EACH IMAGE.
SEEK #1,P : GET$ #1,1,BYTE$             'Get first byte of data stream.
IF ASC(BYTE$) = 44 THEN                 'If img desr follows, continue.
 MORE = 1
 CALL IMGDESCR                          'Get picture specifics.
 SEEK #1,P : GET$ #1,1,BYTE$ : P=P+1    'Get initial compression code size.
 N = ASC(BYTE$) : M = N
 CLC = 2^N                              'CLC = clear code number.
 EOI = (2^N)+1                                'EOI = end of info number.
 SEEK #1,P:GET$ #1,1,BYTE$:BS=ASC(BYTE$)      'Read the blok size.
 BM = P : P=P+1                         'Note the block marker.

 DO
   CALL GETCODE                   'Read next <code> in codestream.
   IF D = CLC THEN                'If clear code encountered, initialize string
      CALL INITST : CALL GETCODE  'table.
   END IF
   IF D < STLEN THEN              'Does <code> exist in the string table?
				  'Yes:output string for <code> to charstream
     PC$ = STABLE$(D) : CALL PRINTCHAR
				  'Get the first char of <code>,
                                  'put together the next string table code
				  'and output it to the string table.
     STABLE$(STLEN) = OLD$ + LEFT$(STABLE$(D),1)
     STLEN = STLEN + 1            'Increment the string table.
     IF STLEN = (2^(N+1)) THEN
       N = N + 1                  'Increment the bit size if needed.
       IF N > 11 THEN N = 11      'If the bit size is 12, change back to
     END IF                       'the maximum bit size (clear code should follow).
     OLD$ = STABLE$(D)            'After saving the code you just read,
   ELSE                           'you will go get a new <code>.
     STABLE$(STLEN) = OLD$ + LEFT$(OLD$,1)
     PC$ = STABLE$(STLEN) : CALL PRINTCHAR
     STLEN = STLEN + 1
     IF D = (2^(N+1))-1 THEN
       N = N + 1                  'Increment the bit size if needed.
       IF N > 11 THEN N = 11      'If the bit size is 12, change back to
     END IF                       'the maximum bit size (clear code should follow).
     OLD$ = STABLE$(D)
   END IF

LOOP UNTIL D = EOI                'Stop outputting the image once the "end of
				  'information " code is read.
ELSE                              'If no more images follow, end program.
 MORE = 0
END IF
LOOP UNTIL MORE  <> 1
GOTO UNCLE

'------------------------------------------------------------------------------
SUB SCRENDESCR                             'Get screen descriptor block info
					   'and set screen resolution size.
SHARED M$,PX,H

FOR S = 0 TO 5                             'Retrieve and print GIF signature.
  SEEK #1,S : GET$ #1,1,BYTE$ :  A$ = A$ + BYTE$
NEXT : ? "GIF SIGNATURE ---> ";A$
					   'Get width and height of screen.
SEEK #1,7 : GET$ #1,1,H$ : SEEK #1,6 : GET$ #1,1,L$
W = ASC(H$)*256 + ASC(L$) : PRINT "WIDTH OF SCREEN -->";W
SEEK #1,9 : GET$ #1,1,H$ : SEEK #1,8 : GET$ #1,1,L$
H = ASC(H$)*256 + ASC(L$) : PRINT "HEIGHT OF SCREEN -->";H

SC = 7                                      'Set screen size.
IF W > 320 THEN SC = 8
IF H > 200 THEN SC = 9
SCREEN SC
ON ERROR GOTO SCRENERR
SCREEN SC
ON ERROR GOTO SCRENERR
SCREEN SC
ON ERROR GOTO SCRENERR
SCREEN SC

SEEK #1,10 : GET$ #1,1,BYTE$                  'Work w/byte #4 of screen descriptor
B$ = BIN$(ASC(BYTE$)) :  B$ = "0000000" + B$
B$ = RIGHT$(B$,8) :? "Byte #4 of Screen Descriptor ---> " B$ : M$ = LEFT$(B$,1)
? "M Value (If M=1 then Global Color Map follows Descriptor) ---> " M$
CR = VAL(MID$(B$,2,1))*4 + VAL(MID$(B$,3,1))*2 + VAL(MID$(B$,4,1))+1
? "CR Value (cr+1 = # bits of color resolution," CR "for this file)---> "MID$(B$,2,3)
SOR = VAL(MID$(B$,5,1)) : ? "Sort Flag --->"SOR
PX = VAL(MID$(B$,6,1))*4 + VAL(MID$(B$,7,1))*2 + VAL(MID$(B$,8,1))+1
? "Pixel Value (pixel+1 = # bits/pixel in image,"; PX; "for this file,"
? "                             which will give"2^PX"colors.)---> "MID$(B$,6,3)

SEEK #1,11 : GET$ #1,1,BYTE$             'Retrieve byte #5 of screen descriptor
B$ = BIN$(ASC(BYTE$)) : B$ = "0000000" + B$ : B$ = RIGHT$(B$,8)
? "Background (color index of screen background -- color is defined from "
? "         the Global color map or default map if none specified.) ---> "B$

SEEK #1,12 : GET$ #1,1,BYTE$             'Retrieve byte #6 of screen descriptor
B$ = BIN$(ASC(byte$)) : b$ = "0000000" + B$ : B$ = RIGHT$(B$,8)
? "Pixel Aspect Ratio Number --->"B$

END SUB
'----------------------------------------------------------------------------
SUB IMGDESCR                       'Image Descripter Subroutine to
				   'get top & left position, width & height,
                                   'and flag and field info for this one image.
SHARED P,L,R,IW,IH

P = P + 1
SEEK #1,P : GET$ #1,1,L$ : SEEK #1,P+1 : GET$ #1,1,H$
L = ASC(H$)*256 + ASC(L$) : PRINT "Image Left Pos -->";L
SEEK #1,P+2 : GET$ #1,1,L$ : SEEK #1,P+3 : GET$ #1,1,H$
R = ASC(H$)*256 + ASC(L$) : PRINT "Image Down Pos -->";R
SEEK #1,P+4 : GET$ #1,1,L$ : SEEK #1,P+5 : GET$ #1,1,H$
IW = ASC(H$)*256 + ASC(L$) : PRINT "Image Width  -->";IW
SEEK #1,P+6 : GET$ #1,1,L$ : SEEK #1,P+7 : GET$ #1,1,H$
IH = ASC(H$)*256 + ASC(L$) : PRINT "Image Height -->";IH
SEEK #1,P+8 : GET$ #1,1,BYTE$ : PRINT "Byte 10 of Image Descriptor -->";BIN$(ASC(BYTE$))
P = P + 9
END SUB
'------------------------------------------------------------------------------
SUB GETCODE                         'This subroutine reads the variable "compacted"
				    'bits within the code bytes, and returns the
				    'appropriate decimal number for the string
SHARED  P,N,D,BM,BS                  'table identifier.
STATIC BIGBYTE$

IF LEN(BIGBYTE$)< 25 THEN
DO
  SEEK #1,P:GET$ #1,1,BYTE$
  IF P = BM+BS+1 THEN
    BM=P : BS=ASC(BYTE$)
    P=P+1
    SEEK #1,P:GET$ #1,1,BYTE$
  ELSE
    P = P + 1
    b$ = bin$(asc(byte$))
    b$ = "0000000000000" + b$
    b$ = right$(b$,8)
    BIGBYTE$=B$+BIGBYTE$
  END IF
LOOP UNTIL LEN(BIGBYTE$) > 25
END IF

F$ = "0000000000000000" + RIGHT$(BIGBYTE$,N+1)
F$ = RIGHT$(F$,12)
BIGBYTE$ = LEFT$(BIGBYTE$,LEN(BIGBYTE$)-N-1)
D=VAL(RIGHT$(F$,1))+VAL(MID$(F$,8,1))*16+VAL(MID$(F$,7,1))*32+VAL(MID$(F$,6,1))*64+VAL(MID$(F$,5,1))*128+VAL(MID$(F$,4,1))*256
D = D + VAL(MID$(F$,3,1))*512+VAL(MID$(F$,2,1))*1024 + VAL(MID$(F$,1,1))*2048
D = D + VAL(MID$(F$,9,1))*8+VAL(MID$(F$,10,1))*4+VAL(MID$(F$,11,1))*2
END SUB
'------------------------------------------------------------------------------
SUB INITST                        'Routine to initialize the string table.

SHARED STABLE$(),M,N,CC,D,STLEN,OLD$,PC$,P

LOCAL ST

N = M                              'Reset number of bits to read
				   'to the original size.
FOR ST = CC + 3 TO  4096           'Erase all strings in the string table
STABLE$(ST) = ""                   'array past the "roots."

NEXT

STLEN = 2^N + 2                    'Reset the string table length.

CALL GETCODE                             'Get the next <code>.
PC$ = STABLE$(D) : CALL PRINTCHAR        'Output the string for <code>
OLD$ = STABLE$(D)                        'Put the output string in <old>
END SUB
'----------------------------------------------------------------------------
SUB PRINTCHAR                   'This routine actually does the plotting of
				'the pixel index values.
SHARED STABLE$(),L,R,IW,IH,D,PC$,H
STATIC X,Y

CLEN = LEN(PC$)
FOR PPIX = 1 TO CLEN
  X=X+1 : IF X > IW  THEN
    X = 1 : Y = Y + 1
     IF Y = IH THEN GOTO UNCLE
     IF Y = H THEN GOTO UNCLE
     IF Y > 350 THEN GOTO UNCLE
  END IF
  CCC=ASC(MID$(PC$,PPIX,1))-1  :  PSET (X-1+L,Y+R),CCC
NEXT

END SUB
'------------------------------------------------------------------------------
SCRENERR:
  SC = SC-1
  IF SC < 7 THEN SC = 2
RETURN
'------------------------------------------------------------------------------
UNCLE:
  BEEP 1                            'Signal end of image processing.
  CLOSE #1
  WHILE NOT INSTAT:WEND
  CALL BSAVEIT
  END
RETURN

'------------------------------------------------------------------------------
SUB BSAVEIT                              'This routine saves a 320x200 portion
					 'of the screen to three binary files.
DIM GGG%(11004),HHH%(11000),III%(10600)

GET (0,0)-(107,199),GGG%                 'Capture the left third of the screen,
DEF SEG = VARSEG(GGG%(0))                'Find out where GGG% is in memory,
BSAVE "GIFBSAVE.1",VARPTR(GGG%(0)),42800 'and write the contents to a binary
					 'file.
GET (108,0)-(215,199),HHH%               'Repeat.
DEF SEG = VARSEG(HHH%(0))
BSAVE "GIFBSAVE.2",VARPTR(HHH%(0)),42800

GET (216,0)-(319,199),III%               'Repeat.
DEF SEG = VARSEG(III%(0))
BSAVE "GIFBSAVE.3",VARPTR(III%(0)),20800




END SUB